/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui.paint;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

class importPCX {
    public static final int NORMAL = 1;
    public static final int RLE = 2;

    importPCX() {
    }

    public static BufferedImage getImage(String in) {
        File file = new File(in);
        try {
            FileInputStream inp = new FileInputStream(file);
            Image buf = importPCX.getImage(inp);
            BufferedImage im = new BufferedImage(buf.getWidth(null), buf.getHeight(null), 1);
            im.createGraphics().drawImage(buf, 0, 0, null);
            return im;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BufferedImage getImage(File file) {
        try {
            FileInputStream inp = new FileInputStream(file);
            Image buf = importPCX.getImage(inp);
            BufferedImage im = new BufferedImage(buf.getWidth(null), buf.getHeight(null), 1);
            im.createGraphics().drawImage(buf, 0, 0, null);
            return im;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Image getImage(InputStream in) {
        Image picture = null;
        byte[] palette16 = new byte[48];
        byte[] filler = new byte[58];
        try {
            int manufacturer = in.read();
            int version = in.read();
            int encoding = in.read();
            int bits_per_pixel = in.read();
            int xmin = in.read() + in.read() * 256;
            int ymin = in.read() + in.read() * 256;
            int xmax = in.read() + in.read() * 256;
            int ymax = in.read() + in.read() * 256;
            int hres = in.read() + in.read() * 256;
            int vres = in.read() + in.read() * 256;
            in.read(palette16);
            int reserved = in.read();
            int color_planes = in.read();
            int bytes_per_line = in.read() + in.read() * 256;
            short palette_type = (short)(in.read() + in.read() * 256);
            in.read(filler);
            int pcxwidth = 1 + xmax - xmin;
            int pcxheight = 1 + ymax - ymin;
            if (pcxwidth % 2 == 1) {
                ++pcxwidth;
            }
            if (bits_per_pixel == 8 && color_planes == 1) {
                byte[] pal = new byte[768];
                int[] intPal = new int[768];
                int imagebytes = pcxwidth * pcxheight;
                int[] imageData = new int[imagebytes];
                importPCX.readRLECompressedData(imagebytes, imageData, in);
                if (in.available() > 769) {
                    while (in.available() > 769) {
                        in.read();
                    }
                }
                if (in.available() != 769) {
                    System.err.println("Error in the palette!");
                }
                if (in.read() != 12) {
                    System.err.println("Error in the palette!");
                }
                in.read(pal);
                in.close();
                for (int y = 0; y < 767; ++y) {
                    intPal[y] = pal[y];
                    if (intPal[y] >= 0) continue;
                    intPal[y] = intPal[y] + 256;
                }
                int[] RGBImageData = new int[imagebytes];
                for (int i = 0; i < imagebytes; ++i) {
                    int paletteEntry = imageData[i];
                    if (paletteEntry < 0) {
                        paletteEntry += 256;
                    }
                    RGBImageData[i] = new Color(intPal[paletteEntry * 3], intPal[paletteEntry * 3 + 1], intPal[paletteEntry * 3 + 2]).getRGB();
                }
                MemoryImageSource prod = new MemoryImageSource(pcxwidth, pcxheight, RGBImageData, 0, pcxwidth);
                picture = Toolkit.getDefaultToolkit().createImage(prod);
            } else if (bits_per_pixel == 8 && color_planes == 3) {
                int imagebytes = pcxwidth * pcxheight * 3;
                int[] imageData = new int[imagebytes];
                importPCX.readRLECompressedData(imagebytes, imageData, in);
                int[] RGBImageData = new int[imagebytes];
                for (int i = 0; i < pcxheight; ++i) {
                    for (int j = 0; j < pcxwidth; ++j) {
                        int red = imageData[i * 3 * pcxwidth + j];
                        int green = imageData[(i * 3 + 1) * pcxwidth + j];
                        int blue = imageData[(i * 3 + 2) * pcxwidth + j];
                        RGBImageData[i * pcxwidth + j] = new Color(red, green, blue).getRGB();
                    }
                }
                MemoryImageSource prod = new MemoryImageSource(pcxwidth, pcxheight, RGBImageData, 0, pcxwidth);
                picture = Toolkit.getDefaultToolkit().createImage(prod);
            } else if (bits_per_pixel == 1 && color_planes == 1) {
                int imagebytes = bytes_per_line * pcxheight;
                int[] imageData = new int[imagebytes];
                importPCX.readRLECompressedData(imagebytes, imageData, in);
                in.close();
                int[] RGBImageData = new int[pcxwidth * pcxheight];
                int width = 0;
                int height = 0;
                for (int i = 0; i < imagebytes; ++i) {
                    int k = 128;
                    while (k > 0) {
                        RGBImageData[pcxwidth * height + width] = (imageData[i] & k) == 0 ? new Color(0, 0, 0).getRGB() : new Color(255, 255, 255).getRGB();
                        k /= 2;
                        if (++width != pcxwidth) continue;
                        k = 0;
                        width = 0;
                        ++height;
                        if (i % 2 != 0) continue;
                        ++i;
                    }
                }
                MemoryImageSource prod = new MemoryImageSource(pcxwidth, pcxheight, RGBImageData, 0, pcxwidth);
                picture = Toolkit.getDefaultToolkit().createImage(prod);
            }
        }
        catch (IOException e) {
            System.err.println("Error reading PCX-File!");
        }
        return picture;
    }

    private static void readRLECompressedData(int imagebytes, int[] imageData, InputStream in) throws IOException {
        int mode = 1;
        int nbytes = 0;
        int abyte = 0;
        for (int i = 0; i < imagebytes; ++i) {
            if (mode == 1) {
                abyte = in.read();
                if (abyte > 191) {
                    nbytes = abyte - 192;
                    abyte = (byte)in.read();
                    if (--nbytes > 0) {
                        mode = 2;
                    }
                }
            } else if (--nbytes == 0) {
                mode = 1;
            }
            imageData[i] = abyte;
            if (imageData[i] >= 0) continue;
            imageData[i] = imageData[i] + 256;
        }
    }
}

